/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.vw.api.VWException;
import filenet.vw.server.VWLogonCredentials;
import filenet.vw.server.VWLogonHandle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class VWLogonResult
implements Serializable {
    protected VWLogonCredentials logonCreds;
    protected VWLogonHandle logonHandle;
    protected int serverId = 0;
    private static final long serialVersionUID = 7440L;

    public static String _get_FILE_DATE() {
        return "$Date:   16 Jan 2005 15:17:08  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   hakpata  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.10  $";
    }

    public VWLogonResult(VWLogonCredentials credentials, VWLogonHandle logonId) {
        this.logonCreds = credentials;
        this.logonHandle = logonId;
    }

    public VWLogonCredentials getLogonCredentials() {
        return this.logonCreds;
    }

    public VWLogonHandle getLogonHandle() {
        return this.logonHandle;
    }

    public void setServerId(int id) {
        this.serverId = id;
    }

    public int getServerId() {
        return this.serverId;
    }

    public static VWLogonResult fromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objIs = new ObjectInputStream(new BufferedInputStream(byteStream));
        VWLogonCredentials lCreds = (VWLogonCredentials)objIs.readObject();
        VWLogonHandle lHandle = (VWLogonHandle)objIs.readObject();
        int svrId = objIs.readInt();
        objIs.close();
        VWLogonResult lResult = new VWLogonResult(lCreds, lHandle);
        lResult.setServerId(svrId);
        return lResult;
    }

    public byte[] toBytes() throws VWException {
        ObjectOutputStream objOs = null;
        try {
            byte[] sendBuf;
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            objOs = new ObjectOutputStream(new BufferedOutputStream(byteStream));
            objOs.writeObject(this.logonCreds);
            objOs.writeObject(this.logonHandle);
            objOs.writeInt(this.serverId);
            objOs.flush();
            byte[] byArray = sendBuf = byteStream.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new VWException("vw.server.VWLogonResult:ToBytesError", "Error while serializing a command to be sent to the server.");
        }
        finally {
            if (objOs != null) {
                try {
                    objOs.close();
                    objOs = null;
                }
                catch (Exception ex) {}
            }
        }
    }
}

